// render navigation bar...
function renderNavbar() {
    var id = SCS.navigationRoot;
    var linkData, navBrand = $("#navbar-brand");

    // add link to Home page...
    if (navBrand) {
        linkData = SCSRenderAPI.getPageLinkData(id) || {};
        if (linkData.href) {
            $(navBrand).attr("href", linkData.href);
        }
    }

    // build navigation menu...
    var navList = $("#navbar-list");
    // add Home link...
    $(navList).append(createNavItem(id));
    // top level pages...
    var curID, navItem, navLink, navID, nodes = SCS.structureMap[id].children;
    for (var n = 0; n < nodes.length; n++) {
        curID = nodes[n];
        // skip hidden node...
        if (isNodeHidden(curID))
            continue;
        
        if ((SCS.structureMap[curID].children.length > 0) && !allNodeChildrenAreHidden(curID)) {
            // add top level node with childeren...
            navItem = document.createElement("li");
            $(navItem).addClass("nav-item dropdown");

            navLink = document.createElement("a");
            $(navLink).addClass("nav-link dropdown-toggle");
            $(navLink).attr("href", "#");
            navID = "navbarDropdown" + SCS.structureMap[curID].name.replace(/\s/g, '');
            $(navLink).attr("id", navID);
            $(navLink).attr("data-toggle", "dropdown");
            $(navLink).attr("aria-haspopup", "true");
            $(navLink).attr("aria-expanded", "false");
            $(navLink).text(SCS.structureMap[curID].name);
            $(navItem).append(navLink);
            
            //sub-menu...
            var navSubList = document.createElement("div");
            $(navSubList).addClass("dropdown-menu dropdown-menu-right");
            $(navSubList).attr("aria-labelledby", navID );
            var subnodes = SCS.structureMap[curID].children;
            for(var sub = 0; sub < subnodes.length; sub++) {
                if (isNodeHidden(subnodes[sub]))
                    continue;
                // add item in the sub-level navigation menu...
                $(navSubList).append(createSubNavItem(subnodes[sub]));
            }
            $(navItem).append(navSubList);

        } else {
            // add rop level node without childeren...
            navItem = createNavItem(curID);
        }

        // add item to the navigation menu...
        $(navList).append(navItem);
    }  
}


// returns <li class="nav-item"> tag for a navigation menu entry...
function createNavItem(id) {
    var navItem = document.createElement("li");
    $(navItem).addClass("nav-item");
    if (id == SCS.navigationCurr)
        $(navItem).addClass("active");

    var navLink = document.createElement("a");
    $(navLink).addClass("nav-link");
    var linkData = SCSRenderAPI.getPageLinkData(id) || {};
    if (linkData.href) {
        $(navLink).attr("href", linkData.href);
    }
    if (linkData.target) {
        $(navLink).attr("target", linkData.target);
    }

    $(navLink).text(SCS.structureMap[id].name);
    $(navItem).append(navLink);

    return navItem;
}

// returns <a class="dropdown-item"> tag for a sub-navigation menu item...
function createSubNavItem(id) {
    var navSubItem = document.createElement("a");
    $(navSubItem).addClass("dropdown-item");
    if (id == SCS.navigationCurr)
        $(navSubItem).addClass("active");
    var linkData = SCSRenderAPI.getPageLinkData(id) || {};
    if (linkData.href)
        $(navSubItem).attr("href", linkData.href);
    if (linkData.target)
        $(navSubItem).attr("target", linkData.target);
    $(navSubItem).text(SCS.structureMap[id].name);

    return navSubItem;
}

// returns true if given navigation node is hidden...
function isNodeHidden(id) {
    var navNode, isHidden = false;
    if (SCS.structureMap) {
        navNode = SCS.structureMap[id];
        if (navNode) {
            isHidden = (true === navNode.hideInNavigation);
        }
    }
    return isHidden;
}

// returns true if all children of given navigation node are hidden...
function allNodeChildrenAreHidden(id) {
    var subnodes = SCS.structureMap[id].children,
        allHidden = ( subnodes.length > 0 ) ? true: false;

    for( var sub = 0; sub < subnodes.length; sub++ ) {
        if( !isNodeHidden( subnodes[sub] ) ) {
            allHidden = false;
            break;
        }
    }
    return allHidden;
}

// must wait for the script to be ready...
if (document.addEventListener) {
    document.addEventListener('scsrenderstart', renderNavbar, false);
} else if (document.attachEvent) {
    document.documentElement.scsrenderstart = 0;
    document.documentElement.attachEvent('onpropertychange', function(event) {
        if (event && (event.propertyName == "scsrenderstart")) {
            renderNavbar();
        }
    });
}
