/* globals define */

define([
	'jquery',
	'mustache',
	'text!./layout.html',
	'css!./design.css'
], function ($, Mustache, templateHtml, css) {
	'use strict';

	function ContentLayout(params) {
		this.contentItemData = params.contentItemData || {};
		this.scsData = params.scsData;
		this.contentClient = params.contentClient;
	}

	function dateToMDY(date) {
		var dateObj = new Date(date);

		var options = {
			year: 'numeric',
			month: 'long',
			day: 'numeric'
		};
		var formattedDate = dateObj.toLocaleDateString('en-US', options);

		return formattedDate;
	}

	ContentLayout.prototype = {

		getAuthors: function () {
			var contentClient = this.contentClient;

			// query back the authors once per page
			if (!window.blogAuthorPromise) {
				window.blogAuthorPromise = new Promise(function (resolve, reject) {
					// get all the authors
					contentClient.getItems({
						'field:type:equals': 'Starter-Blog-Author',
						'fields': 'ALL'
					}).then(function (authors) {
						resolve(authors);
					}, function (error) {
						console.log(error);
						reject({});
					});
				});
			}
			return window.blogAuthorPromise;
		},
		render: function (parentObj) {
			var template,
				contentClient = this.contentClient,
				data = this.contentItemData.data,
				content = {
					blogImageRenditionURL: contentClient.getRenditionURL({
						'id': data['starter-blog-post_header_image'].id
					}),
					blogSummary: data['starter-blog-post_summary'],
					blogTitle: data['starter-blog-post_title'],
					blogContent: data['starter-blog-post_content'],
					blogFormattedDate: dateToMDY(this.contentItemData.updateddate.value)
				},
				contentType,
				secureContent = false;

			if (this.scsData) {
				content = $.extend(content, {
					'scsData': this.scsData
				});
				contentType = content.scsData.showPublishedContent === true ? 'published' : 'draft';
				secureContent = content.scsData.secureContent;
			}

			this.getAuthors().then(function (authors) {
				// get the blog author
				var author = {
					data: {}
				};
				for (var i = 0; i < authors.items.length; i++) {
					if (authors.items[i].id === data['starter-blog-post_author'].id) {
						author = authors.items[i];
						break;
					}
				}
				content.blogAuthor = author.data['starter-blog-author_name'];

				// render the cotent
				try {
					// Mustache
					template = Mustache.render(templateHtml, content);

					if (template) {
						$(parentObj).append(template);
					}
				} catch (e) {
					console.error(e.stack);
				}
			});
		}
	};

	return ContentLayout;
});
